//These variables will get set automatically
texture rubyTexture;
float rubyTimer;
sampler s0 = sampler_state { texture = <rubyTexture>; };

float fScount = 2048;

float4 Noise (float2 Tex)
{
	float2 t = Tex;		
	float x=t.x*t.y*123456 * rubyTimer;
	x=fmod(x,13) * fmod(x,123);	
	float dx = fmod(x,0.01);
	float dy = fmod(x,0.012);
	float4 c=tex2D(s0, t+float2(dx,dy));
	return c;	
}

float4 NoisePass( in float2 Tex : TEXCOORD0 ) : COLOR0
{		
	float4 cTextureScreen = tex2D( s0, Tex.xy); 
	float2 sc; sincos(Tex.y * fScount, sc.x, sc.y);
	//Noise
	float3 cResult = cTextureScreen + cTextureScreen * saturate(Noise(Tex));
	// add scanlines
	cResult += cTextureScreen * float3(sc.x, sc.y, sc.x) * Noise(Tex);
	cResult = lerp(cTextureScreen, cResult, saturate(sin(Noise(Tex) * rubyTimer * 1000)));
	cResult = (cResult.r * 0.3f + cResult.g * 0.59f + cResult.b * 0.11f);
	return float4(cResult, cTextureScreen.a);
}

Technique T0
{
    pass p0 { PixelShader = compile ps_2_0 NoisePass(); }
}

